import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

import java.net.*;
import java.io.*;

public class Checker extends JFrame {
	RemoteGame remotegame;

	boolean blnServer = false;
	boolean blnClient = false;
	int port = 8080;

	JMenuItem mItemServer = new JMenuItem();
	JMenuItem mItemClient = new JMenuItem();
	JMenuItem mItemLocal  = new JMenuItem();
	JMenuItem mItemExit   = new JMenuItem();

	JDesktopPane mdiChecker = new JDesktopPane();

	// Main
	public static void main(String args[]) {
    try {
    	// ]wMetal Look & Feel
      UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
    }
    catch(Exception e) {
      e.printStackTrace();
    }

		Checker mainFrame = new Checker();
    mainFrame.validate();

    // jp
		mainFrame.setSize(410, 450);
    mainFrame.setResizable(true);
    
    // m
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    mainFrame.setLocation((dim.width - mainFrame.getSize().width) / 2, (dim.height - mainFrame.getSize().height) / 2);
		
		mainFrame.setVisible(true);
	}

	// غc禡
	public Checker() {
		super("v (Checker)");
		this.setFont(new java.awt.Font("Dialog", Font.PLAIN, 12));		

		ClassLoader cl = this.getClass().getClassLoader();
		Toolkit tk = Toolkit.getDefaultToolkit();

    setIconImage(tk.createImage(cl.getResource("images/icon.jpg")));
		
		getContentPane().add(mdiChecker);
		
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);
		JMenu menu1 = new JMenu("C");
		menu1.setFont(new java.awt.Font("Dialog", Font.PLAIN, 12));
		JMenu menu2 = new JMenu("su");
		menu2.setFont(new java.awt.Font("Dialog", Font.PLAIN, 12));

		mItemServer = new JMenuItem("A");
		mItemServer.setFont(new java.awt.Font("Dialog", Font.PLAIN, 12));
		mItemServer.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        mItemServer_actionPerformed(e);
      }
    });
    
		mItemClient = new JMenuItem("Τ");
		mItemClient.setFont(new java.awt.Font("Dialog", Font.PLAIN, 12));
		mItemClient.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
        mItemClient_actionPerformed(e);
      }
    });

		mItemLocal = new JMenuItem("HC");
		mItemLocal.setFont(new java.awt.Font("Dialog", Font.PLAIN, 12));
		mItemLocal.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
        mItemLocal_actionPerformed(e);
      }
    });

		mItemExit = new JMenuItem("");
		mItemExit.setFont(new java.awt.Font("Dialog", Font.PLAIN, 12));
		mItemExit.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					dispose();
					System.exit(0);
				}
			}
		);

		menuBar.add(menu1);
		menu2.add(mItemServer);
		menu2.add(mItemClient);
		menu1.add(menu2);
		menu1.add(mItemLocal);
		menu1.addSeparator();
		menu1.add(mItemExit);
				
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				dispose();
				System.exit(0);
			}
		});
	}

	// suCҦ - A
  void mItemServer_actionPerformed(ActionEvent e) {
		remotegame = new RemoteGame();
		remotegame.setServerMode(true);

		try{
			port = Integer.parseInt(JOptionPane.showInputDialog(null, "пJAݩһݤqT.", "v (Checker)", JOptionPane.INFORMATION_MESSAGE));
		}
		catch (NumberFormatException ex) {
			JOptionPane.showMessageDialog(remotegame.checkerFrame, "qT榡~.", "v (Checker)", JOptionPane.ERROR_MESSAGE);
			port = -1;
    }
		
		if (port > 0) {
			remotegame.initialize(mdiChecker, port);
			remotegame.start();
			mItemClient.setEnabled(false);	
			mItemLocal.setEnabled(false);	
		}
  }

	// suCҦ - Τ
  void mItemClient_actionPerformed(ActionEvent e) {
		remotegame = new RemoteGame();
		remotegame.setServerMode(false);

		try{
			port = Integer.parseInt(JOptionPane.showInputDialog(null, "пJAݤqT.", "v (Checker)", JOptionPane.INFORMATION_MESSAGE));
		}
		catch (NumberFormatException ex) {
			JOptionPane.showMessageDialog(remotegame.checkerFrame, "qT榡~.", "v (Checker)", JOptionPane.ERROR_MESSAGE);
			port = -1;
    }

		if (port > 0) {
			String ipAddress = JOptionPane.showInputDialog(null, "пJAݤIP}ΥDW.", "v (Checker)", JOptionPane.INFORMATION_MESSAGE);
			remotegame.initialize(mdiChecker, port, ipAddress);
			remotegame.start();
			mItemServer.setEnabled(false);	
			mItemLocal.setEnabled(false);	
		}
  }

	// HCҦ
  void mItemLocal_actionPerformed(ActionEvent e) {
		CheckerFrame checkerFrame = new CheckerFrame(' ');

		checkerFrame.setTitle("HC (l)");
		checkerFrame.resetCheckerFrame();
		checkerFrame.setCheckerPosition('A',0);
		checkerFrame.setCheckerPosition('B',40);
		checkerFrame.addInternalFrame(mdiChecker);
	}
}
