BOOT     START   0                 BOOTSTRAP LOADER FOR SIC 
. 
. THIS BOOTSTRAP READS CODE FROM DEVICE F1 AND ENTERS IT INTO
. MEMORY STARTING AT ADDRESS 80 (HEX). AFTER ALL OF THE CODE
. HAS BEEN ENTERED INTO MEMORY, THE BOOTSTRAP EXECUTES A 
. JUMP TO ADDRESS 80 TO BEGIN EXECUTION OF THE PROGRAM.
. 
.               REGISTER X = NEXT ADDRESS TO BE LOADED 
. 
         LDA     ZERO              CLEAR REGISTER A TO ZERO 
         LDX     HEX80             INITIALIZE REGISTER X TO HEX 80
LOOP     JSUB    GETC              READ HEX DIGIT 
         MUL     K16               SHIFT DIGIT VALUE LEFT 4 BITS
         STA     TEMP              SAVE SHIFTED DIGIT VALUE 
         JSUB    GETC              GET NEXT HEX DIGIT 
         ADD     TEMP              COMBINE DIGITS TO FORM ONE BYTE
         STCH    0,X               STORE AT ADDRESS IN REGISTER X 
         TIX     ZERO              ADD 1 TO ADDRESS BEING LOADED
         J       LOOP              LOOP UNTIL END OF INPUT
. 
. SUBROUTINE TO READ ONE CHARACTER AND CONVERT IT
. FROM ASCII CODE TO HEX DIGIT VALUE. THE CONVERTED HEX DIGIT 
. VALUE IS RETURNED IN REGISTER A. WHEN AN END-OF-FILE IS READ, 
. CONTROL IS TRANSFERRED TO THE STARTING ADDRESS (HEX 80). 
. 
GETC     TD      INPUT             TEST INPUT DEVICE
         JEQ     GETC              LOOP UNTIL READY 
         RD      INPUT             READ CHARACTER 
         COMP    HEX04             IF CHARACTER IS HEX 04 (EOF),
         JEQ     80                  JUMP TO START OF PROGRAM 
         COMP    HEX30             COMPARE TO HEX 30 (CHAR '0') 
         JLT     GETC              SKIP CHARACTERS LESS THAN '0'
         SUB     HEX30             SUBTRACT HEX 30 FROM ASCII CODE
         COMP    K10               IF RESULT < 10, CONVERSION IS
         JLT     RETURN              COMPLETE. OTHERWISE, SUBTRACT
         SUB     K7                  7 MORE (FOR 'A' THROUGH 'F') 
RETURN   RSUB                      RETURN TO CALLER 
HEX04    BYTE    X'000004'
HEX30    BYTE    X'000030'
HEX80    BYTE    X'000080'
ZERO     WORD    0
K7       WORD    7
K10      WORD    10 
K16      WORD    16 
INPUT    BYTE    X'F1'
TEMP     RESW    1
         lND     BOOT 
