LOADER   START   80                ABSOLUTE LOADER FOR SIC
. 
. THIS LOADER READS AN OBJECT PROGRAM FROM DEVICE F2 AND LOADS IT
. INTO MEMORY. THE HEADER RECORD FOR THE OBJECT PROGRAM IS NOT
. PROCESSED. WHEN THE END RECORD IS READ, THE LOADER JUMPS TO 
. THE INDICATED STARTING ADDRESS.
. 
. ERRORS IN THE OBJECT PROGRAM WILL RESULT IN AN ERROR HALT
. (ON AN ILLEGAL INSTRUCTION TRAP). THE ADDRESS OF THE TRAP 
. (THE BYTES LABELLED HALT1 THROUGH HALT4) WILL INDICATE THE 
. TYPE OF ERROR DETECTED.
. 
.     REGISTER X = NEXT ADDRESS TO BE LOADED 
. 
         JSUB    READCHAR          READ FIRST CHARACTER 
         COMP    HEADREC           CHECK FOR HEADER RECORD
         JEQ     SKIPHEAD          CONTINUE IF HEADER IS PRESENT, 
HALT1    BYTE    X'FF'               OTHERWISE HALT (NO HEADER) 
SKIPHEAD JSUB    SKIPEOL           SKIP THE REST OF THE HEADER
PROCLOOP JSUB    READCHAR          READ FIRST CHAR OF NEXT RECORD 
         COMP    TEXTREC           CHECK FOR TEXT RECORD
         JEQ     PROCTEXT 
         COMP    ENDREC            CHECK FOR END RECORD 
         JEQ     PROCEND
HALT2    BYTE    X'FF'             ERROR HALT (UNKNOWN REC TYPE)
PROCTEXT JSUB    GETADDR           GET ADDRESS FROM TEXT RECORD 
         LDA     ZERO 
         JSUB    GETD              GET FIRST HEX DIGIT OF LENGTH
         MUL     K16               SHIFT LEFT 4 BITS
         STA     TEMP              SAVE SHIFTED VALUE 
         JSUB    GETD              GET SECOND HEX DIGIT OF LENGTH 
         ADD     TEMP              COMBINE TO FORM LENGTH OF TEXT 
         ADD     ADDRESS           ADD STARTING ADDRESS OF TEXT 
         STA     LIMIT             SAVE RESULT AS LIMIT ADDRESS 
         LDX     ADDRESS           LOAD TEXT ADDRESS INTO REG X 
TEXTLOOP LDA     ZERO 
         JSUB    GETD              GET FIRST DIGIT OF OBJECT BYTE 
         MUL     K16               SHIFT LEFT 4 BITS
         STA     TEMP              SAVE SHIFTED VALUE 
         JSUB    GETD              GET SECOND DIGIT OF OBJECT BYTE
         ADD     TEMP              COMBINE TO FORM BYTE VALUE 
         STCH    0,X               STORE IN MEMORY
         TIX     LIMIT             ADD 1 TO ADDRESS BEING LOADED
         JLT     TEXTLOOP          LOOP UNTIL LIMIT REACHED 
         JSUB    SKIPEOL           SKIP REMINDER OF RECORD AND EOL
         J       PROCLOOP          GO TO PROCESS NEXT RECORD
PROCEND  JSUB    GETADDR           GET ADDRESS FROM END RECORD
         LDX     ADDRESS           LOAD INTO REGISTER X 
         J       0,X               JUMP TO STARTING ADDRESS 
. 
. THIS SUBROUTINE READS AN ADDRESS FROM AN OBJECT PROGRAM
. RECORD (6 HEX DIGITS) AND STORES IT IN INTEGER FORM IN THE 
. VARIABLE NAMED ADDRESS.
. 
GETADDR  STL     RETGA             SAVE RETURN ADDRESS
         LDX     ZERO              INITIALIZE ADDRESS TO ZERO 
         STX     ADDRESS
ADDRLOOP JSUB    GETD              GET HEX DIGIT OF ADDRESS 
         STA     TEMP 
         LDA     ADDRESS           SHIFT ADDRESS LEFT 4 BITS
         MUL     K16
         ADD     TEMP              ADD IN NEW HEX DIGIT VALUE 
         STA     ADDRESS
         TIX     K6                LOOP UNTIL ALL 6 DIGITS
         JLT     ADDRLOOP            HAVE BEEN PROCESSED
         LDL     RETGA             RETURN TO CALLER 
         RSUB 
. 
. THIS SUBROUTINE READS THE NEXT CHARACTER OF THE OBJECT PROGRAM 
. 
READCHAR LDA     ZERO 
READLOOP TD      INPUT             TEST INPUT DEVICE
         JEQ     READLOOP          LOOP UNTIL READY 
         RD      INPUT             READ CHARACTER 
         RSUB                      RETURN TO CALLER 
. 
. THIS SUBROUTINE READS ONE CHARACTER FROM THE INPUT AND COVERTS 
. IT FROM ASCII CODE TO HEX DIGIT VALUE. THE CONVERTED HEX
. DIGIT VALUE IS RETURNED IN REGISTER A
. 
GETD     STL     RETGD             SAVE RETURN ADDRESS
GETDLOOP JSUB    READCHAR          READ CHARACTER 
         COMP    HEX04             IF END OF FILE,
         JEQ     HALT3               GO TO ERROR HALT 
         COMP    HEX30             COMPARE TO CHARACTER '0' 
         JLT     GETDLOOP          SKIP CHARACTERS LESS THAN '0'
         SUB     HEX30             SUBTRACT HEX 30 FROM ASCII CODE
         COMP    K10               IF RESULT < 10, CONVERSION IS
         JLT     RETURN              COMPLETE. OTHERWISE, SUBTRACT
         SUB     K7                  7 MORE (FOR 'A' THROUGH 'F') 
         COMP    K10               CHECK FOR ILLEGAL HEX DIGITS 
         JLT     HALT4             GO TO ERROR HALT IF ILLEGAL
         COMP    K15
         JGT     HALT4
RETURN   LDL     RETGD             RETURN TO CALLER 
         RSUB 
HALT3    BYTE    X'FF'             ERROR HALT (PREMATURE EOF) 
HALT4    BYTE    X'FF'             ERROR HALT (ILLEGAL HEX DIGIT) 
. 
. THIS SUBROUTINE SKIPS THE REST OF THE CURRENT OBJECT 
. PROGRAM RECORD, INCLUDING THE END-OF-LINE MARKER 
. 
SKIPEOL  STL     RETS              SAVE RETURN ADDRESS
EOLLOOP  JSUB    READCHAR          READ CHARACTER 
         COMP    ZERO              CHECK FOR END-OF-LINE
         JEQ     EXIT              EXIT IF END-OF-LINE FOUND
         J       EOLLOOP           LOOP 
EXIT     LDL     RETS              RETURN TO CALLER 
         RSUB 
HEADREC  BYTE    X'000048'         CHARACTER 'H'
TEXTREC  BYTE    X'000054'         CHARACTER 'T'
ENDREC   BYTE    X'000045'         CHARACTER 'E'
ZERO     WORD    0
K2       WORD    2
K6       WORD    6
K7       WORD    7
K10      WORD    10 
K15      WORD    15 
K16      WORD    16 
HEX04    BYTE    X'000004'         END-OF-FILE
HEX30    BYTE    X'000030'         CHARACTER '0'
INPUT    BYTE    X'F2'
ADDRESS  RESW    1
LIMIT    RESW    1
TEMP     RESW    1
RETGA    RESW    1
RETGD    RESW    1
RETS     RESW    1
         END     LOADER 
