# 2003/11/10 By Yung-Pin Cheng
#    description: In the project of shared memeory
#                 I wrote a user program like
#                     if ((j % 10) == 0) 
#                         printf("hello world);
#                 This type of user program does not work because instrumentation code
#                 treat the code as two separate statements
#                 Be sure to use 
#                     if ((j%10) == 0) {
#                         printf("hello world");
#                     }
#                 instead
#                 
# 2003/11/3 By Yung-Pin Cheng
#    description: In the project of shared memory,
#                 it is possible to use a char *p to do array reference such as p[i].
#                 Dont use the array reference like p [i] in user programs
# 2003/10/25 By Yung-Pin Cheng
#    description: In the project of share memory accessing,
#                 we need to deal with the case of "char *p"
#                 and use "p" as an array in the user program.
# 
# 2003/10/8 By Yung-Pin Cheng
#    description: Do not have any variable name appear in a string
#                 such as printf("%d",d);
#   
# 2003/10/8 By Yung-Pin Cheng
#    description: We have a test case like
#                       printf("j=%d",j);
#                 The awk script will translate it into
#                       printf("(*memint("j",2,1))=%d", (*memint("j",2,0)));
#                 This is an obvious drawback which use AWK as a parser
#                 So, please do not use such test cases.
#
#
# 2003/10/7 By Yung-Pin Cheng
#    description: we have a test case use array like p[i*1024+i] = 100 ;
#                 However, our awk script does not parse the index inside
#                 the array. So, please does not allow test files which 
#                 contain statements like that.
#
#
BEGIN {
   err[0] = "(AWKOS ERR):Please rewrite variable declaration in separated lines !";
   err[1] = "(AWKOS ERR);Please rewrite int i,j; into int i; int j ; in separate lines";
   err[2] = "(AWKOS ERR);You probably have something illegal before main(). Have you use struct or typedef before main?" ;
   err[3] = "(AWKOS ERR):Weird, the last line of the code is not }. If you mix } with other, please separate them." ;
   err[4] = "(AWKOS ERR):You probably write \n main() \n { int i; \n ..... \n in the program. \n please separate { and variable declaration in different lines ";
   err[5] = "(AWKOS ERR):We only support one dimension array in user programs. ";
   
   mstr = "int stepctr = 0 ;\n";
   mstr = mstr "#include \"awkos_list.h\" \n"  ;
   mstr = mstr "#include \"awkos_pgtable.h\" \n";
   mstr = mstr "#include \"awkos_sched.h\" \n" ;
   mstr = mstr "#include \"awkos_memacc.h\" \n" ;
   mstr = mstr "struct task_struct *prev ;\n" ;

   mstr = mstr "#define saveaddr(labelno) \\\n" ;
   mstr = mstr "    current->addr = labelno ;\\\n" ;
   mstr = mstr "    prev = current \n" ;
   mstr = mstr "#define stepincr(lableno,syscall) \\\n" ;
   mstr = mstr "    stepctr++ ; \\\n";
   mstr = mstr "    if (syscall == 0) { \\\n" ;
   mstr = mstr "      if (stepctr >= qtime) { \\\n" ;
   mstr = mstr "        stepctr = 0 ; \\\n" ;
   mstr = mstr "        prev = current ; \\\n" ;       
   mstr = mstr "        current->addr = lableno ; \\\n" ;
   mstr = mstr "        do_timer(); \\\n";
   mstr = mstr "      } \\\n " ;
   mstr = mstr "    }  \\\n " ;
   mstr = mstr "      if (current != prev) { \\\n" ;
   mstr = mstr "       prev = current ; \\\n" ;
   mstr = mstr "       switch(current->addr) { \\"  ;

   sstr = "#define saveaddress(labelno) \\\n" ;
   sstr = sstr " current->address = labelno \n" ;
   
         
 
   

   istr =  " int mi ; for (mi=0;mi<= awkfileno;mi++) exectimes[mi] = 0 ; \n" ;
   istr = istr "     for (mi=0;mi<= awkfileno;mi++) \n" ;
   istr = istr "       _sys_exec(start_addr[mi],filename[mi]);\n" ;
   
 
   	
               
   
   MAXFNO = 20 ;
   includeno = 0 ;
   cfilename = "" ;
   fileno = 1 ;
   filename[0] = "init.c" ;
   filename[1] = "awksh.c" ;
   
   ofile = "awklinuxos.c" ;
   for (i=0;i<MAXFNO; i++) {
      codeno[i] = 0 ;
      declno[i] = 0 ;
      varno[i] = 0 ;
   }
   codestr[0,0]=" while (1) {";
   codestr[0,1]="   idle(); } " ;
   codeno[0] = 2 ;
      
   declstr[0,0] = "int IDLE_i;" ;
   declno[0] = 1 ;
   
   codestr[1,0]=" while (1) { " ;
   codestr[1,1]="   check_command();} " ;
    codeno[1] = 2 ;
   
   declstr[1,0] = "int INIT_i;" ;
   declno[1] = 1 ;
   
   
}
/./ {
    if (FILENAME != cfilename)  {
        fileno ++ ;
        filename[fileno] = FILENAME ;
        cfilename = FILENAME ;
    }
}
/./ {   
    if (NF == 0) { next ; }
	
}

/#include/ { 
#   we get the include file name
#   the reasons that we do this is not to duplicate the include
#   in the final progall.c

    includestr = substr($0, match($0,/<[a-zA-Z_\-\/]+\.h>/), RLENGTH);
    iret = getinclude(includestr);
    if (iret == 0) {
       includename[includeno] = includestr ;
       includeno ++ ;
       print $0 > ofile ;
    }
    next ;
}
/(int|char|float|long) .*,/ { printerr(err[1]); exit 1 ;}
/(int|char|float|long) .*;.*;/{ printerr(err[0]); exit 1 ; }
/(int|char|float|long) *\* *+[a-zA-Z_][a-zA-Z0-9_]* *;/ {
#	
# This line is used to extract pointer type declaration such as char *p ;	
#
	 typestr = substr($0, match($0,/(int|char|float|long)/), RLENGTH);
	 str1 = substr($0,match($0,/\*/)+1);
	 str2 = substr(str1, match(str1,/[a-zA-Z_][a-zA-Z0-9_]*/), RLENGTH);
	
	 varname[fileno,varno[fileno]]  = str2 ;
         vartype[fileno,varno[fileno]] = typestr "ptr" ;
         varlen[fileno, varno[fileno]] = 1 ;
	 declstr[fileno,declno[fileno]] = $0 ;
	 declno[fileno] ++ ;
	 varno[fileno] ++ ;
	 next ;
}
  
/(int|char|float|long) +[a-zA-Z_][a-zA-Z0-9_]* *;/ {
	varname[fileno,varno[fileno]]  = rmsemiequal($2); # the $2 may be like "x=1;" which is not
                                                          # a clean variable name, so we rmsemiequal
                                                          # to get a clean variable name
        vartype[fileno, varno[fileno]] = $1 ;
        varlen[fileno, varno[fileno]] = 1 ;
	declstr[fileno,declno[fileno]] = $0 ;
	declno[fileno] ++ ;
	varno[fileno] ++ ;
	next ;
}
/(int|char|float|long) +[a-zA-Z_][a-zA-Z0-9_]* *=.*;/ { 
	varname[fileno,varno[fileno]] = rmsemiequal($2);

        vartype[fileno, varno[fileno]] = $1 ;
        varlen[fileno, varno[fileno]] = 1 ;
	declstr[fileno,declno[fileno]] = $0 ;
	declno[fileno] ++ ;
	varno[fileno] ++ ;
	next ;
}
/(int|char|float|long) +[a-zA-Z_][a-zA-Z0-9_]* *\[[0-9]+\] *;/ {
        varname[fileno,varno[fileno]] = rmbrackets($2);
        
        vartype[fileno, varno[fileno]] = $1 ;
        varlen[fileno, varno[fileno]] = getarraylen($0);
	declstr[fileno,declno[fileno]] = $0 ;
	declno[fileno] ++ ;
	varno[fileno] ++ ;
	next ;
}
/(int|char|float|long) +[a-zA-Z_][a-zA-Z0-9_]* *\[[0-9]+\]\[[0-9]+\]/ {

        printerr(err[5]);
}
# 
# The above lines should have captured variable declaration lines
# if a source line can reach here, it must be a code 
#

/./ {
	
	codestr[fileno,codeno[fileno]] = $0 ;
	codeno[fileno] ++ ;
#	print codestr[fileno,codeno[fileno]-1] ;

}
#########################################################################
#  The end of regular expression handling routines
#########################################################################
END {
   #- compute data segment address for each variable
   for (i=2;i<= fileno ; i++) 
       computeaddr(i);
 
   #- for code segment of each file
   #- we use rm_main_tail to remove the "main() {" and "}"
   #- we use rename_variable to rename the variable name into (* memint(p,1,10))
   #- both in decl[] and codestr[]

   for (i=2;i<= fileno ; i++) {
   	rm_main_tail(i); 
   	rename_variable(i);
   }
	
   #- compute the label range of each user program
   #- startaddress[i] is the starting label no. of file i

   st= 0 ;
   for (i=0;i<=fileno;i++) {
   	startaddress[i] = st ;
   	st += codeno[i] ;
   }

   #- print start address for each program
   tempstr = "" ;
   for (i=0;i<=fileno;i++) {
      tempstr = tempstr startaddress[i] ;
      if (i != fileno ) tempstr = tempstr "," ;
   }
   print "#define MAXFNO 20" >> ofile ;
   print "int awkfileno = " fileno " ;" >> ofile ;
   print "int start_addr[MAXFNO]={" tempstr "};\n" >> ofile ;
   print "int exectimes[MAXFNO];\n" >> ofile ;
   print "#define qtime 5 \n" >> ofile 
   
   tempstr = "" ;
   for (i=0;i<=fileno; i++) {
      tempstr = tempstr "\"" filename[i] "\"" ;
      if (i != fileno) tempstr = tempstr "," ;
   }
   print "char * filename[] = { " tempstr "};\n" >> ofile ;
   
   #- print file name without .c 
   tempstr = "" ;
   for (i=0;i<=fileno; i++) {
      tempstr = tempstr "\"" substr(filename[i],1,length(filename[i])-2) "\"" ;
      if (i != fileno) tempstr = tempstr "," ;
   }
   print "char * execfilename[] = { " tempstr "};\n" >> ofile ;
   
   
   # ------ print macro
   print mstr >> ofile ;
   for (i=0;i<st; i++) {
      print "        case " i " : goto L" i " ; \\" >> ofile ;
   }
   print "         } \\" >> ofile ;
   print "       } \\" >> ofile ;
   
   	
   # ------ print variable definition
   for (i=0;i<= fileno; i++) {
     print "// definition of prog " i >> ofile ;
     for (j=0;j< declno[i]; j++) 
     	print declstr[i,j] >> ofile ;
   }
   
   # ------ print main program
      
   print "main() {" >> ofile ;
   print istr >> ofile ;
   st = 0 ;
   presys_call = 0 ;
   sys_call = 0 ;
   for (i=0;i<=fileno; i++) {
     print "// code of prog " i >> ofile ;
     for (j=0;j< codeno[i]; j++) {
     	sys_call= process_syscall(codestr[i,j]);
     	if (sys_call == 1)
     	   print "stepincr(" st "," presys_call "); L" st ": saveaddr(" st+1 ");"  codestr[i,j]  memaccessstr[i,j]  >> ofile ;
     	else
      	   print "stepincr(" st "," presys_call "); L" st ": " codestr[i,j]  memaccessstr[i,j]  >> ofile ;
 	presys_call = sys_call ;
     	st ++ ;
    
     }
     print "     sys_exit();" >> ofile ;
     
   }
   print "}" >> ofile ;
   
}
#--------------------------------
#
#---------------------------------
function computeaddr(fileno) {
 startaddr = 0 ;
 for (cti=0; cti < varno[fileno] ; cti++) {
    print varname[fileno, cti] "=" startaddr ;
    varaddr[fileno, cti] = startaddr ;
    if (vartype[fileno, cti] == "int") {
        startaddr =  startaddr+ 4 * varlen[fileno, cti] ;
    } 
    if (vartype[fileno, cti] == "char") {
         startaddr =  startaddr+ 1 * varlen[fileno, cti] ;
    }
    if (vartype[fileno, cti] == "float") {
         startaddr =  startaddr+ 4 * varlen[fileno, cti] ;
    } 
    if (vartype[fileno, cti] == "long") {
       startaddr =  startaddr+ 4 * varlen[fileno, cti] ;
    }
} 
}

#----------------------------------------------------------
# This function is no longer used
#----------------------------------------------------------
function process_memaccess(codestr,fileindex) {

  start = 1 ;
  result = "" ;
# we repeat until we can not find any word in this line 
  remain = codestr ;

  while (match(remain,/[a-zA-Z_][a-zA-Z0-9_]*/) != 0) {
    rentemp = substr(remain,RSTART, RLENGTH);
    start = start + RSTART + RLENGTH -1 ;
    b4remain = remain ;
    remain = substr(codestr,start);
    if (exist_in_var(rentemp,fileindex) == 1) {
      
      if (isarray(rentemp,fileindex) == 1) {
	indexstr = substr(remain,2,index(remain,"]")-2);
	if (match(remain,"=") != 0)
	  result = result "arymemacc(" addr_of_var(rentemp, fileindex) "," indexstr ",1);" ;
	else
	  result = result "arymemacc(" addr_of_var(rentemp, fileindex) "," indexstr ",0);" ;
	
      } else {
	# now we check if the variable is at LHS of an assignment
	if (match(remain,"=") != 0) 
	  result = result "dmemacc(" addr_of_var(rentemp, fileindex) ",1);" ; 
	else
	  result = result "dmemacc(" addr_of_var(rentemp, fileindex) ",0);" ;
      }
    }
 
  }
  return result ;
}

#-------------------------------------------------------------
# process_syscall check if codestr contains system call
# If yes, return 1, if no, return 0
#-------------------------------------------------------------
function process_syscall(codstr) {
   if (match(codstr,/sys_sleep *\([0-9]+ *\)/) != 0) {
     return 1 ;
   } 
   if (match(codstr,/sys_semget/) != 0) {
     return 1 ;
   }
   if (match(codstr,/sys_semop/) != 0) {
     return 1 ;
   }
   if ( match(codstr,/sys_shmget/) != 0) {
     return 1 ;
   }
   if ( match(codstr,/sys_shmat/) != 0) {
     return 1 ;
   }
   return 0 ;
   
}
function addr_of_var(str, fileno) {

  for (exi=0;exi< varno[fileno]; exi++ ) {
       if (varname[fileno, exi] == str) 
          return varaddr[fileno,exi] ;
    }
    return 0 ;	
}
function type_of_var(str,fileno) {
   for (exi=0;exi< varno[fileno]; exi++ ) {
       if (varname[fileno, exi] == str) 
          return vartype[fileno,exi] ;
    }
    return 0 ;	
}    
#------------------------------------------
# Given an identifier, we check if the identifier is an array.
# In case of a pointer, we check if [] in the remaining string
#-------------------------------------------------------------
function isarray(str,myindex,remainstr) {
    for (exi=0;exi< varno[myindex]; exi++ ) {
      if (varname[myindex, exi] == str) {
				if (varlen[myindex,exi] > 1 ) 
	  			return 1 ;
	  		if (match(vartype[myindex,exi],"ptr") != 0)  {
	  			if (index(remainstr,"[") == 1) 
	  			   return 1 ;		
	  		}
	  	}
    }
    return 0 ;	
}

function exist_in_var(str,myindex) {
    for (exi=0;exi< varno[myindex]; exi++ ) {
       if (varname[myindex, exi] == str) 
          return 1 ;
    }
    return 0 ;	
}
#---------------------------------------------------
# This function is an old one which rename variable
# "j" into "USERi_j" where i is the fileindex number
#---------------------------------------------------
function rename_one_line(linestr,fileindex) {
	c = 0 ;
        start = 1 ;
        result = "" ;
        # we repeat until we can not find any word in this line 
        remain = linestr ;
        while (match(remain,/[a-zA-Z_][a-zA-Z0-9_]*/) != 0) {
            rentemp = substr(remain,RSTART, RLENGTH);
            #print "rentemp = " rentemp ;
            start = start + RSTART + RLENGTH -1 ;
            #print "===" start ;
            # we add the string before RSTART to result
            if (RSTART > 1 ) result = result substr(remain,1,RSTART-1);
            remain = substr(linestr,start);
            
            found = exist_in_var(rentemp,fileindex);
	    if (found == 1)
	        result = result "USER" fileindex "_" rentemp ;
	    else
	        result = result rentemp ;
	    
       }
       result = result substr(linestr,start);
       return result ;
}
#----------------------------------------------------------
function rename_one_line_by_addr(codestr,fileindex) {

  start = 1 ;
  result = "" ;
# we repeat until we can not find any word in this line 
  remain = codestr ;
  #print "DEBUG:" codestr ;
  while (match(remain,/[a-zA-Z_][a-zA-Z0-9_]*/) != 0) {
    rentemp = substr(remain,RSTART, RLENGTH);
    start = start + RSTART + RLENGTH -1 ;
    b4remain = remain ;
    # before the first matched word, there may be some strings before
    # the matched word
    if (RSTART > 1) result = result substr(remain,1,RSTART-1);
    remain = substr(codestr,start);
   
    if (exist_in_var(rentemp,fileindex) == 1) {
      if (isarray(rentemp,fileindex,remain) == 1) {
				indexstr = substr(remain,2,index(remain,"]")-2);
				#print "DEBUG: indexstr = " indexstr ;
				indextypestr = type_of_var(indexstr,fileindex) ;
				#print "debug: (indextypestr)" indextypestr ;
				
				# indexstr2 contains the transformed string of array index
				if (indextypestr == 0) {
				    # the index of the array could be a constant
				    indexstr2 = indexstr ;
				} else 	
				    indexstr2 = "(*memint(\"" indexstr "\"," addr_of_var(indexstr, fileindex) ",0))" ;
				
				# get rid of [x] from the remain
				start = start + index(remain,"]");
				remain = substr(codestr, start);
					
	      typestr = type_of_var(rentemp, fileindex);
				#print "debug: (typestr)" rentemp "-" typestr ;
				
				rw = 0 ;			
				if (match(remain,"=") != 0) {
					  rw = 1 ;
				}
				if (refbyptr(typestr) == 1 )	{
					    puretypestr = substr(typestr,1, length(typestr)-3);
					    #print "DEBUG: " puretypestr ;
					    addrofarray = "(*mem" typestr "(\"" rentemp "\"," addr_of_var(rentemp, fileindex) ",0))" ;
							result = result "(*ary" puretypestr "(\"" rentemp "\"," addrofarray "," indexstr2 "," rw "))" ;
				}
				else
							result = result "(*ary" typestr "(\"" rentemp "\"," addr_of_var(rentemp, fileindex) "," indexstr2 "," rw "))" ;
	 		 
      } else {
					# now we check if the variable is at LHS of an assignment
					typestr = type_of_var(rentemp, fileindex);
					if (match(remain,"=") != 0) 
	  					result = result "(*mem" typestr "(\"" rentemp "\"," addr_of_var(rentemp, fileindex) ",1))" ; 
					else
	  					result = result "(*mem" typestr "(\"" rentemp "\"," addr_of_var(rentemp, fileindex) ",0))" ;
      }
    } else 
    	result = result rentemp ;
  } #--- end of while 
  result = result substr(codestr,start);
  return result ;
}
#------------------------------------------------------
#  
#------------------------------------------------------
function refbyptr(str) {
	if (str == "intptr" || str == "charptr" || str == "longptr")
	  return 1 ;
	return 0 ;
}



# ------------------------------------------------------  
#  We have kept all the variable name in varname[]
#  use that symbol table as a reference
#  rename_variable() first rename the name in declstr[]
#  second, it rename the names in codestr[]
# ------------------------------------------------------
function rename_variable(fileindex) {
    for (re_i=0; re_i < declno[fileindex]; re_i++) {
    	retemp = declstr[fileindex,re_i] ;
    	newstr = rename_one_line(retemp,fileindex);
    	if (newstr != retemp )
    	    declstr[fileindex,re_i] = newstr ;
    }
    for (re_i=0; re_i < codeno[fileindex] ; re_i++) {
    	retemp = codestr[fileindex,re_i] ;
    	newstr = rename_one_line_by_addr(retemp,fileindex);
    	if (newstr != retemp )
    	    codestr[fileindex,re_i] = newstr ;
    }
} 
# -------------------------------------------------------
# the codestr[] of each file contains "main()" and "}" 
# We need to remove these statements while we combine
# user programs into one
# -------------------------------------------------------
function rm_main_tail(rmi) {
    
    if (index(codestr[rmi,0],"main") == 0) {
    	printerr2(filename[rmi],err[2]);
        exit 1 ;
    }
    if (index(codestr[rmi,0],"main") != 0) {
       if (index(codestr[rmi,0],"{") != 0) 
          codestr[rmi,0] = " " ;
       else if (match(codestr[rmi,1], /{ *$/) != 0) {
          codestr[rmi,0] = " " ;
       	  codestr[rmi,1] = " " ;
       } else {
          printerr2(filename[rmi],err[4]);
          exit 1;
       }
    }
 
    rm_last = codeno[rmi]-1 ;
    if (match(codestr[rmi,rm_last],/} *$/) == 0) {
       printerr(err[3]);
       exit 1 ;
    }
    codeno[rmi] -- ;
    
}
# ----------------------------------------------------------------
# When we get an variable declaration line, it can be "int x=1;"
# So, the second word is not a clean variable name
# this function, we first check if "=" is in 2nd word
# If yes, we return the clean variable name ;
# ----------------------------------------------------------------
function rmsemiequal(str) {
   rm_ret = index(str,"=");
   if (rm_ret != 0)
       return substr(str,1,rm_ret-1);	
   rm_ret = index(str,";");
   if (rm_ret != 0)
       return substr(str,1,rm_ret-1);
   return str ;
}
#
#  functions to process arrary declaration
#
function getarraylen(str) {
   gal_st = index(str,"[") ;
   gal_ed = index(str,"]"); 
  return substr(str, gal_st+1, gal_ed-gal_st-1);
}
function rmbrackets(str) {
  rmb_ed = index(str,"[");
  return substr(str,1,rmb_ed-1);
}



function getinclude(includestr) {
   for (gei=0;gei< includeno;gei++) {
      if (includename[gei]==includestr)
          return 1 ;
   }
   return 0 ;
}       
function printerr(msg) {
      print FILENAME ":" FNR ":" msg ;
}

function printerr2(fname,msg) {
     print fname ";" msg ;
}
       
function checkmulti() {
   if (NF > 3) {
      printerr(err[0]);
      exit 1 ;
   }
}
