
#define  _SCHED_ 
#include "awkos_list.h"
#include "awkos_pgtable.h"
#include "awkos_sched.h"

extern reg_t cr2 ;

#define idle_task (&init_task)

void switch_to(struct task_struct *p) {
  current = p ;
  p->need_resched = 0 ;
  cr2 = p->mm->pgd ;
}


void schedule(void) {

  	struct task_struct *prev, *next, *p;
	struct list_head *tmp;
	int c;

	repeat_schedule:
	/*
	 * Default process to select..
	 */
	next = idle_task ;
	c = -1000;
	list_for_each(tmp, &runqueue_head) {
		p = list_entry(tmp, struct task_struct, run_list);
		if (p->state ==  TASK_RUNNING ) {
			int weight = p-> counter ;
			if (weight > c)
			  c = weight, next = p;
		}
	}
	/* Do we need to re-calculate counters? */
	if (!c) {
		struct task_struct *p;
		for_each_task(p)
		  p->counter = INIT_COUNT ;
		
		goto repeat_schedule;
	}

	/*
	 * from this point on nothing can prevent us from
	 * switching to the next task, save this fact in
	 * sched_data.
	 */
        switch_to(next);
}


