#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include "awkos_list.h"
#include "awkos_pgtable.h"
#include "awkos_sched.h" 


#define MAXFNO 30 

extern int start_addr[MAXFNO] ;
extern char *filename[MAXFNO] ;
extern int awkfileno ;
int process_no = 0 ;
extern reg_t cr2 ;




struct task_struct * alloc_task_struct() {
  struct task_struct *p ;
  p = (struct task_struct *) malloc(sizeof(struct task_struct));
  p->prev_task = NULL ;
  p->next_task ;

}
void free_task_struct(struct task_struct *p) {
  free(p);
}

void sys_exit() {
	
  list_del(&(current->run_list)); /* delete current pcb from runqueue first */
  REMOVE_LINKS(current);          /* delete  current pcb from process_list */
  current = NULL ;
  process_no -- ;
  if (process_no == 2) {
      printf("\n\n NO USER PROCESSES, AWKOS terminated \n\n");
      exit(0);
  }
  schedule();
}

void _sys_exec(int startaddr, char *file) {
  struct task_struct * newp ;
  process_no ++ ;
 if (strcmp(file,"init.c") == 0) {
 
  init_task.state = TASK_RUNNING;
  init_task.need_resched = 0 ;
  init_task.counter = INIT_COUNT ;
  init_task.next_task = &init_task ;
  init_task.prev_task = &init_task ;
  init_task.run_list.prev = NULL ;
  init_task.run_list.next = NULL ;
  init_task.pid = maxpid ;
  maxpid ++ ;
  
  // alloc a page directory table
  init_task.mm = (struct mm_struct *) malloc(sizeof(struct mm_struct));
  init_task.mm->pgd = alloc_one_frame();
  
  init_task.addr = startaddr ;
  init_task.file = (char *) malloc(strlen(file)+5);
  strcpy(init_task.file, file);
  list_add_tail(&(init_task.run_list),&runqueue_head);	
  current = &init_task ;
 }  else {	
 	
  newp = alloc_task_struct() ;
  newp->state = TASK_RUNNING;
  newp->need_resched = 0 ;
  newp->counter = INIT_COUNT ;
  newp->next_task = NULL ;
  newp->prev_task = NULL ;
  (newp->run_list).prev = NULL ;
  (newp->run_list).next = NULL ;
  newp->pid = maxpid ;
  maxpid ++ ;
  // alloc a page directory table
  newp->mm = (struct mm_struct *) malloc(sizeof(struct mm_struct));
  newp->mm->pgd = alloc_one_frame();
  
  // internel information stored by awklinux
  newp->addr = startaddr ;
  newp->file = (char *) malloc(strlen(file)+5);
  strcpy(newp->file, file);
  
  
  SET_LINKS(newp); /* add the pcb to the process list led by init_task */
  list_add_tail(&(newp->run_list), &runqueue_head); /* add  the pcb to runqueue */
  
 }
     
  
}

void sys_exec(char *_name) {
 
     int i ;
     for (i=0;i<= awkfileno;i++) {
        if (strcmp(filename[i],_name) == 0)
            break ;
     }
     if (i > awkfileno) {
        printf("runtime err: %s file not found\n",_name) ;
        return ;
     }
     _sys_exec(start_addr[i],filename[i]);
} 


