#include <stdio.h>
#define TASK_RUNNING		0
#define TASK_INTERRUPTIBLE	1
#define INIT_COUNT 20 


#define for_each_task(p) \
        for (p = &init_task;  (p= p->next_task) != &init_task ; ) 

#define SET_LINKS(p) do { \
        (p)->next_task = &init_task; \
        (p)->prev_task = init_task.prev_task; \
        init_task.prev_task->next_task = (p); \
        init_task.prev_task = (p); \
         } while (0)

#define REMOVE_LINKS(p) do { \
        (p)->next_task->prev_task = (p)->prev_task; \
        (p)->prev_task->next_task = (p)->next_task; \
         } while (0)


struct mm_struct {
  pgd_t pgd; /* the address of page directory */
  unsigned long start_code, end_code, start_data, end_data;
  unsigned long start_brk, brk, start_stack;
  unsigned long rss, total_vm, locked_vm;
  unsigned long def_flags;
};




struct task_struct {
  /*
   * offsets of these are hardcoded elsewhere - touch with care
   */
  volatile long state;	/* -1 unrunnable, 0 runnable, >0 stopped */
  volatile long need_resched;
  long counter;
  /*
   * (only the 'next' pointer fits into the cacheline, but
   * that's just fine.)
   */
  struct list_head run_list;
  struct task_struct *next_task, *prev_task;
  int pid;
  char * file ;
  long addr ;
  struct mm_struct *mm ;
};

#ifdef _SCHED_
LIST_HEAD(runqueue_head);
struct task_struct * current ;
struct task_struct init_task ;
int nr_running ;
int maxpid = 0 ;

#else
extern struct list_head runqueue_head ;
extern struct task_struct * current ;
extern struct task_struct init_task ;
extern int nr_running ;
extern int maxpid ;

#endif

static inline void add_to_runqueue(struct task_struct * p)
{
        list_add(&p->run_list, &runqueue_head);
        nr_running++;
}

static inline void move_last_runqueue(struct task_struct * p)
{
        list_del(&p->run_list);
        list_add_tail(&p->run_list, &runqueue_head);
}

static inline void move_first_runqueue(struct task_struct * p)
{
        list_del(&p->run_list);
        list_add(&p->run_list, &runqueue_head);
}
static inline void del_from_runqueue(struct task_struct * p)
{
	nr_running--;
	/* p->sleep_time = jiffies; */
	list_del(&p->run_list);
	p->run_list.next = NULL;
}

