#include <stdio.h>
#include "awkos_pgtable.h"
#define PTE_LEN 4

reg_t cr2 ;


/* 
 *  One logical address consists of three parts
 *       p1          p2      offset
 *  +----------+----------+------------+
 *  |0000000000|0000000000|000000000000|
 *  +----------+----------+------------+
 *  HIGH                              LOW
 *
 *  One page table/page directory entry occupies 4 bytes 
 *          20 bits          12 bits
 *  +--------------------+------------+
 *  |00000000000000000000|00000D0000RP|
 *  +---------------------------------+
 *  HIGH 	                           LOW
 *  P: present bit
 *  R: read/write bit
 *  D: dirty bit
 */
 
phyaddr_t  two_level_paging(logaddr_t  addr) {
  unsigned long  offset ;
  unsigned long p1, p2 ;
  phyaddr_t pte_addr, pde_addr, phyaddr ;
  pte_t pte, pde ;
  phyaddr_t pgtable_phyaddr ;
  
  offset = addr & 0xFFF ; // get the offset of the logical address
  p2 = (addr & 0x3FF000) >> 12 ; // get the p2
  p1 = (addr & 0xFFC00000 ) >> 22 ; // get the p1
  
  
  pde_addr = (cr2 + p1 * PTE_LEN); // get the page directory entry by p1
  pde = (*(pte_t *)(pde_addr)); 
  if (!pte_present(pde)) {
  	do_page_fault(addr);
  	pde = (*(pte_t *)(pde_addr)); 
  }
  pgtable_phyaddr = pde & 0xFFFFF000 ; // purge the lower 12 bits
  
  
  
  pte_addr = pgtable_phyaddr + p2 * PTE_LEN ; // get the page table entry by p2
  pte = (*(pte_t *)(pte_addr));
  if (!pte_present(pte)) {
  	do_page_fault(addr);
  	pte = (*(pte_t *)(pte_addr));
  }
  phyaddr = (pte & 0xFFFFF000) + offset ; // compute the physical address
  
  return phyaddr ;
}

int * memint(char *varname, logaddr_t addr, int flag) {

  return (int *) two_level_paging(addr);
  
}

long * memlong(char *varname, logaddr_t addr, int flag) {
  return (long *) two_level_paging(addr);
  
}

char * memchar(char *varname, logaddr_t addr, int flag) {
  return (char *) two_level_paging(addr);
  
}

int * memintptr(char *varname, logaddr_t addr, int flag) {

  return (int *) two_level_paging(addr);
  
}

int * memlongptr(char *varname, logaddr_t addr, int flag) {
  return (int *) two_level_paging(addr);
  
}

int * memcharptr(char *varname, logaddr_t addr, int flag) {
  return (int *) two_level_paging(addr);
  
}

int * aryint(char *varname, logaddr_t base, int index, int flag) {
  phyaddr_t p ;
  p = two_level_paging(base + index * sizeof(int)) ;
  return (int *) p ;
}
char * arychar(char *varname, logaddr_t base, int index, int flag) {
  phyaddr_t p ;
  p = two_level_paging(base + index * sizeof(char));
  return (char *) p ;
}
long * arylong(char *varname, logaddr_t base, int index, int flag) {
  phyaddr_t p ;
  p = two_level_paging(base + index * sizeof(long));
  return (long *) p ;

}

/*

main() {

  phyaddr_t levelone_pt , leveltwo_pt, data ;
  pte_t * p ;
  pte_t pgtval, pteval ;
  pte_t * pteentry_ptr, * pgtentry_ptr ;
  char * q;
  int i ;

  levelone_pt = alloc_one_frame();
  leveltwo_pt = alloc_one_frame();

  data = alloc_one_frame();
  for (i=0;i<= 52; i++) {
    q = (char *) (data + i * sizeof(char)) ;
    (*q) = (char) i+ 65 ;
  }

  cr2 = levelone_pt ; // point the page directory base register to pd
  //  p = (pte_t *) cr2 ;
  //(*p) = pt ;
  //p = (pte_t *) pt ;
  //(*p) = data ;
  
  pgtentry_ptr = pgd_offset(cr2,0);
  pgtval = mk_pte_phys(leveltwo_pt, _PAGE_PRESENT);
  set_pgd(pgtentry_ptr, pgtval);
  
  pteentry_ptr = pte_offset(pgtentry_ptr,0);
  pteval = mk_pte_phys(data, _PAGE_PRESENT);
  set_pte(pteentry_ptr, pteval);
   
  for (i=0;i< 52; i++) {
  	printf("-%c-\n", (*arychar("a",0,i,1)));
  }

  printf("-%c-\n", (*memchar("a",0,1)));
  printf("-%c-\n", (*memchar("a",1,1))); 
  printf("-%c-\n", (*memchar("a",2,1))); 
  printf("-%c-\n", (*memchar("a",3,1))); 
  printf("-%c-\n", (*memchar("a",4,1)));
  


}
*/
 

  

  
  
  
  
  
  
   
