import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

public class CheckerFrame extends JInternalFrame implements MouseListener { 
 	CheckerBoard checkergrid[][] = new CheckerBoard[8][8];
 	char checkerdisc[][] = new char[8][8];
  int selx = -1;
  int sely = -1;

	// ѤlC
  Color colorA = Color.red;
  Color colorB = Color.black;

	// ѤUѤlƥ
  byte numpieceA = 0;
  byte numpieceB = 0;

  char cTurn = 'A';
  char cName = ' ';

	// ѤlO_U (l)
  public boolean blnFirst = false;
	// O_suCҦ
  boolean blnRemote = false;

	// XƬy]Output Stream^
  ObjectOutputStream outData;
  
	// غc禡
 	public CheckerFrame(char cName) {
		super("v (Checker)",true, true);
		
		this.setFont(new java.awt.Font("Dialog", Font.PLAIN, 12));		
		this.cName = cName;
		setTitle("v (Checker)");
		setMaximizable(true);
		setIconifiable(true);
		setResizable(true);

		addMouseListener(this);
		
		Container contentPane = getContentPane();
		contentPane.setLayout(new GridLayout(8, 8));   

  	for (int iRow = 0; iRow < 8; iRow++)	{
			for (int iCol = 0; iCol < 8; iCol++)	{
  			checkergrid[iRow][iCol] = new CheckerBoard();      			

				contentPane.add(checkergrid[iRow][iCol]);
  		}
    }
	
		// ]ѽL
  	resetCheckerFrame();
  	
  	// ]wlm
  	setCheckerPosition('A',0);
  	// ]w¤lm
  	setCheckerPosition('B',40);
  		
  	setSize(400,400);
  }

	public void addInternalFrame(JDesktopPane main)	{
		main.add(this);
		// javax.swing.JComponent.setOpaque(boolean)
		setOpaque(true);
		show();
	}

	// ]wXƬy]Output Stream^
	public void setOutputStream(ObjectOutputStream outData) {
		this.outData = outData;

		try {
			outData.flush();
    }
    catch (IOException io) {
      io.printStackTrace();
    }
	}
	
	public void setRemoteMode(boolean blnRemote)	{
		this.blnRemote = blnRemote;
	}
	
	// ]ѽL
  public void resetCheckerFrame() {
  	for (int posX = 0; posX < 8; posX++) {
			for (int posY = 0; posY < 8; posY++) {
  			if (posX % 2 == 0) {
  				if (posY % 2 == 0)
  					checkerdisc[posX][posY] = ' ';
  				else
  					checkerdisc[posX][posY] = '*';
  			}
  			else {
  				if (posY % 2 != 0)
  					checkerdisc[posX][posY] = ' ';
  				else
  					checkerdisc[posX][posY] = '*';
  			}
    			
  			if (checkerdisc[posX][posY] == '*')	{
  				checkergrid[posX][posY].setBackground(Color.white);
  				checkergrid[posX][posY].setForeground(Color.white);
  			}
  			else {
					checkergrid[posX][posY].setBackground(new Color(0,128,128));
					checkergrid[posX][posY].setForeground(new Color(0,128,128));
  			}
  		}
  	}
	}

	public void setCheckerPosition(char cTurn, int posAdd)	{
		int pos = 0;
		
		if (cTurn == 'A' || cTurn == 'B')	{
			for (int cont = 0; cont < 12; cont++)	{
				while(pos < 32)	{
					if (checkerdisc[(pos + posAdd) / 8][(int)((pos + posAdd) % 8)] == ' ') {	
						checkerdisc[(pos + posAdd) / 8][(int)((pos + posAdd) % 8)] = cTurn;
						
						if (cTurn == 'A')	{
							checkergrid[(pos + posAdd) / 8][(int)((pos + posAdd) % 8)].setForeground(colorA);
							numpieceA++;
						}
						else if (cTurn == 'B') {
							checkergrid[(pos + posAdd) / 8][(int)((pos + posAdd) % 8)].setForeground(colorB);
							numpieceB++;
						}
						break;
					}
					pos++;
				}
			}
		}
	}

	// Mim
	private void findPossible(int x, int y)	{
		int posX = 0;
		int posY = 0;
	
		// l
		if (checkerdisc[x][y] == 'A' && cTurn == 'A') {
			if (x<7) {
				if (y<7) {
					if (checkerdisc[x+1][y+1] == 'B' && y<6 && x<6){
						if (checkerdisc[x+2][y+2] == ' ') {
							checkergrid[x+2][y+2].setPossible(true,Color.cyan);
						}
					}
					if (checkerdisc[x+1][y+1] == ' ') {
						checkergrid[x+1][y+1].setPossible(true,Color.cyan);
					}
				}
				if (y>0){
					if (checkerdisc[x+1][y-1] == 'B' && x<6 && y>1){
						if (checkerdisc[x+2][y-2] == ' ') {
							checkergrid[x+2][y-2].setPossible(true,Color.cyan);
						}
					}
					if (checkerdisc[x+1][y-1] == ' ') {
						checkergrid[x+1][y-1].setPossible(true,Color.cyan);
					}
				}
			}

			if (x>0 && checkergrid[x][y].isCrown()) {
				if (y<7){
					if (checkerdisc[x-1][y+1] == 'B' && y<6 && x>1){
						if (checkerdisc[x-2][y+2] == ' ') {
							checkergrid[x-2][y+2].setPossible(true,Color.cyan);
						}
					}
					if (checkerdisc[x-1][y+1] == ' ') {
						checkergrid[x-1][y+1].setPossible(true,Color.cyan);
					}
				}
				if (y>0){
					if (checkerdisc[x-1][y-1] == 'B' && x>1 && y>1){
						if (checkerdisc[x-2][y-2] == ' ') {
							checkergrid[x-2][y-2].setPossible(true,Color.cyan);
						}
					}
					if (checkerdisc[x-1][y-1] == ' ') {
						checkergrid[x-1][y-1].setPossible(true,Color.cyan);
					}
				}
			}
		}
	
		// ¤l
		if (checkerdisc[x][y] == 'B' && cTurn == 'B') {
			if (x>0){
				if (y<7){
					if (checkerdisc[x-1][y+1] == 'A' && y<6 && x>1){
						if (checkerdisc[x-2][y+2] == ' ') {
							checkergrid[x-2][y+2].setPossible(true,Color.cyan);
						}
					}
					if (checkerdisc[x-1][y+1] == ' ') {
						checkergrid[x-1][y+1].setPossible(true,Color.cyan);
					}
				}
				if (y>0){
					if (checkerdisc[x-1][y-1] == 'A' && x>1 && y>1){
						if (checkerdisc[x-2][y-2] == ' ') {
							checkergrid[x-2][y-2].setPossible(true,Color.cyan);
						}
					}
					if (checkerdisc[x-1][y-1] == ' ') {
						checkergrid[x-1][y-1].setPossible(true,Color.cyan);
					}
				}
			}

			if (x<7 && checkergrid[x][y].isCrown()) {
				if (y<7) {
					if (checkerdisc[x+1][y+1] == 'A' && y<6 && x<6){
						if (checkerdisc[x+2][y+2] == ' ') {
							checkergrid[x+2][y+2].setPossible(true,Color.cyan);
						}
					}
					if (checkerdisc[x+1][y+1] == ' ') {
						checkergrid[x+1][y+1].setPossible(true,Color.cyan);
					}
				}
				if (y>0){
					if (checkerdisc[x+1][y-1] == 'A' && x<6 && y>1){
						if (checkerdisc[x+2][y-2] == ' ') {
							checkergrid[x+2][y-2].setPossible(true,Color.cyan);
						}
					}
					if (checkerdisc[x+1][y-1] == ' ') {
						checkergrid[x+1][y-1].setPossible(true,Color.cyan);
					}
				}
			}
		}
	}

	// 洫
	public void setTurn()	{
		cTurn = (cTurn == 'A' ?  'B' : 'A');
	}
	
	// ʴѤl
	public void movePiece(int x0, int y0, int x1, int y1)	{
		movePiece(x0, y0, x1, y1, true);
	}

	// ʴѤl
	public void movePiece(int x0, int y0, int x1, int y1, boolean local) {
		if (checkerdisc[y0][x0] != ' ') {
			CheckerBoard srcPos = checkergrid[y0][x0];
			CheckerBoard tarPos = checkergrid[y1][x1];
			
			checkerdisc[y1][x1] = checkerdisc[y0][x0];
			checkerdisc[y0][x0] = ' ';
			
			tarPos.setForeground(srcPos.getForeground()); 
			srcPos.setForeground(srcPos.getBackground());
			
			if ((y1 == 7 && checkerdisc[y1][x1] == 'A') || (y1 == 0 && checkerdisc[y1][x1] == 'B') || (srcPos.isCrown())) {
				tarPos.setCrown(true);
			}
			
			checkergrid[y0][x0].setCrown(false);
			
			if (local && blnRemote) {
				try {
					outData.writeObject((String) "MOVE");
					outData.flush();
					outData.writeObject((String) Integer.toString(x0) + "," +	Integer.toString(y0) + "," + 	Integer.toString(x1) + "," + Integer.toString(y1));
					outData.flush();
		    }
		    catch (IOException io) {
	        io.printStackTrace();
		    }
			}
		}
	}
	
	// YѤl
	public void eatPiece(int x, int y) {
		eatPiece(x, y, false);
	}

	// YѤl
	public void eatPiece(int x, int y, boolean local)	{
		// ѤUѤlƥػ
		if (checkerdisc[y][x] == 'A') {
			numpieceA--;
		}	else if (checkerdisc[y][x] == 'B') {
			numpieceB--;
		}
			
		checkerdisc[y][x] = ' ';
		checkergrid[y][x].setCrown(false);
		checkergrid[y][x].setForeground(checkergrid[y][x].getBackground());
		
		if (local && blnRemote){
			try {
				outData.writeObject((String) "EAT");
				outData.flush();
				outData.writeObject((String) Integer.toString(x) + "," + Integer.toString(y));
				outData.flush();
      }
	    catch (IOException io) {
        io.printStackTrace();
      }
		}
	}

	public void mouseReleased(MouseEvent e) {
		int x = 0;
		int y = 0;
		
		if (!blnFirst && cTurn == cName || !blnRemote){
			if (numpieceA > 0 && numpieceB > 0) {		
				x = (e.getX()) / (super.getWidth() / 8);
				y = (e.getY() - 13) / (super.getHeight() / 8);

				if (checkergrid[y][x].isPossible()) {
					if (Math.abs(selx - x) == 2){
						eatPiece((selx + x) / 2,(sely + y) / 2,true);
					}
					
					movePiece(selx,sely,x,y);
		
					if (numpieceA == 0)
						JOptionPane.showMessageDialog(this, "¤.", "v (Checker)", JOptionPane.INFORMATION_MESSAGE);			
		
					if (numpieceB == 0)
						JOptionPane.showMessageDialog(this, ".", "v (Checker)", JOptionPane.INFORMATION_MESSAGE);			
		
					if (cTurn == 'A')	{
						cTurn = 'B';
					}
					else{
						cTurn = 'A';
					}
				}
				
				for (int posX = 0; posX < 8; posX++) {
					for (int posY = 0; posY < 8; posY++) {
						checkergrid[posY][posX].setSelected(false, Color.red);
						selx = sely = -1;
					}
				}
				
				for (int posX = 0; posX < 8; posX++) {
					for (int posY = 0; posY < 8; posY++) {
						checkergrid[posY][posX].setPossible(false, Color.cyan);
					}
				}

				if (checkerdisc[y][x] != ' ' && checkerdisc[y][x] != '*') {
					checkergrid[y][x].setSelected(true,Color.red);
					selx = x;
					sely = y;
					findPossible(y,x);
				}
			}
		}
	}
	
	public void mouseClicked(MouseEvent e){}
	public void mousePressed(MouseEvent e){}
	public void mouseEntered(MouseEvent e){}
	public void mouseExited(MouseEvent e){}
}
