import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class CheckerBoard extends JPanel{
	boolean blnSelected = false;
	boolean blnPossible = false;
	boolean blnCrown = false; // O_[(Crown)
	Color selColor = null;
	Color posColor = null;
	Graphics g_board = null;
	
  Image imgDisc[], imgCrown[];

	// غc禡
	public CheckerBoard() {
		ClassLoader cl = this.getClass().getClassLoader();
		Toolkit tk = Toolkit.getDefaultToolkit();
    MediaTracker mt = new MediaTracker(this);

    imgDisc = new Image[2];
    imgCrown = new Image[2];

    imgDisc[0] = tk.createImage(cl.getResource("images/red.jpg"));

    if (imgDisc[0] != null)
      mt.addImage(imgDisc[0], 0);

    imgDisc[1] = tk.createImage(cl.getResource("images/black.jpg"));

    if (imgDisc[1] != null)
      mt.addImage(imgDisc[1], 1);

    imgCrown[0] = tk.createImage(cl.getResource("images/redcrown.jpg"));

    if (imgCrown[0] != null)
      mt.addImage(imgCrown[0], 2);

    imgCrown[1] = tk.createImage(cl.getResource("images/blackcrown.jpg"));

    if (imgCrown[1] != null)
      mt.addImage(imgCrown[1], 3);

    try {
      mt.waitForID(0);
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }

	}

	public void paintComponent(Graphics g) {
	  super.paintComponent(g);
	  
	  g_board = g;

	  if (blnCrown){
	  	// øsw[äѤl
			if (this.getForeground() == Color.red)
	    	g.drawImage(imgCrown[0], 0, 0, super.getWidth(), super.getHeight(), this);
			else if (this.getForeground() == Color.black)
	    	g.drawImage(imgCrown[1], 0, 0, super.getWidth(), super.getHeight(), this);
	  }
	  else {
			// øsѤl
			if (this.getForeground() == Color.red)
	    	g.drawImage(imgDisc[0], 0, 0, super.getWidth(), super.getHeight(), this);
			else if (this.getForeground() == Color.black)
	    	g.drawImage(imgDisc[1], 0, 0, super.getWidth(), super.getHeight(), this);
		}
		
	  if (blnSelected){
			// øswѤlѮ~
			g_board.setColor(selColor);
			g_board.drawRect(0,0, super.getWidth()-1, super.getHeight()-1);
			g_board.drawRect(1,1, super.getWidth()-3, super.getHeight()-3);
	  }
	  if (blnPossible){
			// øsiUѤlѮ~
			g_board.setColor(posColor);
			g_board.drawRect(0,0, super.getWidth()-1, super.getHeight()-1);
			g_board.drawRect(1,1, super.getWidth()-3, super.getHeight()-3);
	  }
	}
	
	public void setSelected(boolean blnSelected, Color selColor) {
		this.blnSelected = blnSelected;
		this.selColor = selColor;
		repaint();
	}
	
  public void setPossible(boolean blnPossible, Color posColor) {
		this.blnPossible = blnPossible;
		this.posColor = posColor;
		repaint();
	}	
	
	public void setCrown(boolean blnCrown) {
		this.blnCrown = blnCrown;
	}	
	
	public boolean isPossible() {
		return blnPossible;
	}
	
	public boolean isSelected() {
		return blnSelected;
	}
	
	public boolean isCrown()	{
		return blnCrown;
	}
}